function StressTest (rate) {
	if (!rate) rate = 160
		
	testingLoop = setInterval (Test, rate)
	moveLogLog = {}
	repeats = 0
	
	console.clear()	
	
	document.addEventListener ("click", CollateTest, false)
}

function Test () {
	if (Math.random() < 0.5 && floats.length != 0) {
		Go (floats[Math.floor(Math.random() * floats.length)].target)
	} else {
		Run()
	}
	
	for(var j = 0; j < boxes.length; j++) {
		if (boxes[j].innerHTML == "Out of bounds") RepeatTest()
		if (boxes[j].className == "box error") clearInterval(testingLoop)
	}
}

function RepeatTest () {
	state = {}
	i = -1
	Clear ("float")
	
	for(var k = 0; k < moveLog.length; k++) {
		console.log (moveLog[k])
		
		if (moveLogLog[moveLog[k]])
			moveLogLog[moveLog[k]] += 1
		else
			moveLogLog[moveLog[k]] = 1
	}
	
	moveLog = []
	repeats++
	
	console.log ("-----")
}

function CollateTest () {
	clearInterval (testingLoop)
	
	keysSorted = Object.keys(moveLogLog).sort(function(a, b) {
		return moveLogLog[b] - moveLogLog[a]
	})
	
	for(var j = 0; j < keysSorted.length; j++)
		console.log (keysSorted[j] + " " + Math.floor(moveLogLog[keysSorted[j]] / repeats * 100) + "%")
	
	console.log ("-----")
	
	document.removeEventListener ("click", CollateTest, false)
}